/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.batch;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.apache.commons.io.output.TeeOutputStream;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.JythonUtil;
import org.autoplot.RunBatchTool;
import org.autoplot.ScriptContext2023;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.Param;
import org.autoplot.jythonsupport.ui.Util;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.python.util.InteractiveInterpreter;

public class BatchProcessor {
    private static final Logger logger = LoggerManager.getLogger((String)"jython.runbatch");
    private int threads = 8;
    public static final String PROP_THREADS = "threads";
    private String writePngTemplate = "";
    public static final String PROP_WRITEPNGTEMPLATE = "writePngTemplate";
    private String statusMessage = "";
    public static final String PROP_STATUSMESSAGE = "statusMessage";
    private File resultsFile = null;
    public static final String PROP_RESULTSFILE = "resultsFile";
    private File batchDirectory = null;
    public static final String PROP_BATCHDIRECTORY = "batchDirectory";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private static String[] maybeSplitMultiParam(String param) {
        if (param.contains("|")) {
            return param.split("\\|", -2);
        }
        if (param.contains(",")) {
            return param.split(",", -2);
        }
        if (param.contains(";")) {
            return param.split(";", -2);
        }
        return null;
    }

    private static void setParam(InteractiveInterpreter interp, String pwd, Param paramDescription, String paramName, String f1) throws IOException {
        if (paramDescription == null) {
            throw new IllegalArgumentException("expected to see parameter description!");
        }
        switch (paramDescription.type) {
            case 'R': 
            case 'U': {
                if (f1.startsWith("'") && f1.endsWith("'") && f1.length() > 1) {
                    f1 = f1.substring(1, f1.length() - 1);
                }
                URISplit split = URISplit.parse((String)f1);
                URI uri = split.path == null ? DataSetURI.getResourceURI((String)(pwd + f1)) : DataSetURI.getResourceURI((String)f1);
                interp.set("_apuri", (Object)uri);
                interp.exec("autoplot2025.params['" + paramName + "']=_apuri");
                break;
            }
            case 'L': {
                interp.exec("autoplot2025.params['" + paramName + "']=URL('" + f1 + "')");
                break;
            }
            case 'M': {
                interp.exec("from java.io import File");
                interp.exec("autoplot2025.params['" + paramName + "']=File('" + f1 + "')");
                break;
            }
            case 'A': {
                if (f1.startsWith("'") && f1.endsWith("'") && f1.length() > 1) {
                    f1 = f1.substring(1, f1.length() - 1);
                }
                interp.exec("autoplot2025.params['" + paramName + "']='" + f1 + "'");
                break;
            }
            case 'T': {
                try {
                    DatumRange timeRange = DatumRangeUtil.parseTimeRange((String)f1);
                    interp.set("_apdr", (Object)timeRange);
                    interp.exec("autoplot2025.params['" + paramName + "']=_apdr");
                }
                catch (ParseException ex) {
                    Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                interp.exec("autoplot2025.params['" + paramName + "']=" + f1);
            }
        }
    }

    private String doWrite(String template, String f1, String f2, String uri, Application dom) throws IOException {
        String[] ss;
        Preferences prefs = Preferences.userNodeForPackage(RunBatchTool.class);
        prefs.put("lastTemplate", template);
        template = template.replaceAll("\\$x", "%s");
        f1 = f1.replaceAll("/", "_");
        f2 = f2.replaceAll("/", "_");
        f1 = f1.replaceAll(" ", "_");
        f2 = f2.replaceAll(" ", "_");
        f1 = f1.replaceAll(":", "_");
        f2 = f2.replaceAll(":", "_");
        ArrayList<String> argList = new ArrayList<String>();
        if (f1.contains(";")) {
            ss = f1.split("\\;", -2);
            argList.addAll(Arrays.asList(ss));
        } else if (f1.trim().length() > 0) {
            argList.add(f1);
        }
        if (f2.contains(";")) {
            ss = f2.split("\\;", -2);
            argList.addAll(Arrays.asList(ss));
        } else if (f2.trim().length() > 0) {
            argList.add(f2);
        }
        ss = template.split("\\%");
        boolean packArgments = false;
        if (argList.size() != ss.length - 1) {
            if (ss.length == 3) {
                packArgments = true;
            } else {
                throw new IllegalArgumentException("PNG template and number of parameters don't match");
            }
        }
        Object[] args = new Object[argList.size()];
        block4: for (int i = 0; i < argList.size(); ++i) {
            int c;
            String spec = packArgments ? "x" : ss[i + 1];
            int idx = 0;
            int n = c = spec.length() > 0 ? (int)spec.charAt(0) : 32;
            while (idx < spec.length() && (c == 45 || c == 46 || Character.isDigit((char)c))) {
                c = spec.length() > 0 ? (int)spec.charAt(++idx) : 32;
            }
            if (idx == spec.length()) {
                throw new IllegalArgumentException("expected to see non-digit in template after %");
            }
            char letter = spec.charAt(idx);
            if (letter == 's') {
                args[i] = argList.get(i);
                continue;
            }
            switch (letter) {
                case 'd': {
                    args[i] = Integer.valueOf((String)argList.get(i));
                    continue block4;
                }
                case 'e': 
                case 'f': {
                    args[i] = Double.valueOf((String)argList.get(i));
                    continue block4;
                }
                default: {
                    args[i] = argList.get(i);
                }
            }
        }
        String s = packArgments ? String.format(template, f1, f2) : String.format(template, args);
        if ((s = s.replaceAll(" ", "_")).endsWith(".png")) {
            BufferedImage bufferedImage = dom.getController().getScriptContext().writeToBufferedImage();
            LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
            metadata.put("ScriptURI", uri);
            metadata.put("plotInfo", dom.getController().getApplicationModel().getCanvas().getImageMetadata());
            dom.getController().getScriptContext().writeToPng(bufferedImage, s, metadata);
        } else if (s.endsWith(".pdf")) {
            dom.getController().getScriptContext().writeToPdf(s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendResultsPendingCSV(File pendingFile, JSONObject results, JSONArray resultsArray, int recordsWrittenAlready, int count) throws FileNotFoundException, IOException {
        boolean header = recordsWrittenAlready == 0;
        Class<RunBatchTool> clazz = RunBatchTool.class;
        synchronized (RunBatchTool.class) {
            try (PrintWriter out = new PrintWriter(new FileWriter(pendingFile, true));){
                StringBuilder record;
                if (resultsArray.length() == 0) {
                    logger.warning("no records in results");
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                JSONObject jo = resultsArray.getJSONObject(0);
                boolean hasOutputFile = jo.has("writeFile");
                JSONArray params = results.getJSONArray("params");
                if (header) {
                    record = new StringBuilder();
                    record.append("jobNumber");
                    for (int j = 0; j < params.length(); ++j) {
                        record.append(",");
                        record.append(params.get(j));
                    }
                    record.append(",").append("executionTime(ms)");
                    if (hasOutputFile) {
                        record.append(",").append("writeFile");
                    }
                    record.append(",").append("exception");
                    out.println(record.toString());
                }
                int stop = recordsWrittenAlready + count;
                for (int i = recordsWrittenAlready; i < stop; ++i) {
                    String resultString;
                    int inl;
                    Object o = resultsArray.opt(i);
                    if (o == null || !(o instanceof JSONObject)) continue;
                    jo = (JSONObject)o;
                    record = new StringBuilder();
                    record.append(i);
                    for (int j = 0; j < params.length(); ++j) {
                        record.append(",");
                        record.append(jo.get(params.getString(j)));
                    }
                    record.append(",").append(jo.get("executionTime"));
                    if (hasOutputFile) {
                        record.append(",").append(jo.get("writeFile"));
                    }
                    if ((inl = (resultString = jo.optString("result", "")).indexOf("\n")) >= 0) {
                        inl = resultString.indexOf("\n", inl + 1);
                    }
                    if (inl >= 0) {
                        inl = resultString.indexOf("\n", inl + 1);
                    }
                    if (inl >= 0) {
                        resultString = resultString.substring(0, inl).replaceAll("\n", " ").replaceAll(",", "");
                    }
                    record.append(",").append(resultString);
                    out.println(record.toString());
                }
                out.flush();
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject doOneJob(int jobNumber, String pwd, String scriptUri, String script, Map<String, Param> parameterDescriptions, Map<String, String> params, String param1Name, String param1Value, String param2Name, String param2Value, final ProgressMonitor monitor) throws RuntimeException {
        URISplit split = URISplit.parse((String)scriptUri);
        String name = split.file;
        param1Value = param1Value.trim();
        param1Name = param1Name.trim();
        JSONObject runResults = new JSONObject();
        try {
            String msg;
            ByteArrayOutputStream outs;
            ByteArrayOutputStream outbaos;
            ApplicationModel appmodel = new ApplicationModel();
            appmodel.addDasPeersToAppAndWait();
            Application myDom = appmodel.getDom();
            ScriptContext2023 scriptContext = new ScriptContext2023();
            myDom.getController().setScriptContext(scriptContext);
            if (!scriptContext.isModelInitialized()) {
                scriptContext.setApplicationModel(appmodel);
            }
            myDom.getController().getScriptContext();
            NullProgressMonitor myMonitor = new NullProgressMonitor(){

                public boolean isCancelled() {
                    return monitor.isCancelled();
                }
            };
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, myDom, (ProgressMonitor)myMonitor);
            interp.exec(JythonRefactory.fixImports((String)"import autoplot2025"));
            LinkedHashMap<String, String> scriptParams = new LinkedHashMap<String, String>();
            scriptParams.putAll(params);
            if (monitor.isCancelled()) {
                return null;
            }
            interp.set("PWD", (Object)split.path);
            String[] paramNames1 = BatchProcessor.maybeSplitMultiParam(param1Name);
            if (paramNames1 != null) {
                char splitc = param1Name.charAt(paramNames1[0].length());
                String[] paramValues = param1Value.trim().split("\\" + splitc);
                for (int j = 0; j < paramNames1.length; ++j) {
                    String p = paramNames1[j].trim();
                    String v = paramValues[j].trim();
                    if (!parameterDescriptions.containsKey(p)) {
                        if (p.trim().length() == 0) {
                            throw new IllegalArgumentException("param1Name not set");
                        }
                        throw new IllegalArgumentException("param not found: " + p);
                    }
                    BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(p), p, v);
                    runResults.put(p, (Object)v);
                    scriptParams.put(p, v);
                }
            } else {
                if (!parameterDescriptions.containsKey(param1Name) && param1Name.length() == 0) {
                    throw new IllegalArgumentException("param1Name not set");
                }
                for (Map.Entry<String, String> e : params.entrySet()) {
                    String pname = e.getKey();
                    if (parameterDescriptions.get(pname) == null) continue;
                    BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(pname), pname, e.getValue());
                }
                BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(param1Name), param1Name, param1Value);
                runResults.put(param1Name, (Object)param1Value);
                scriptParams.put(param1Name, param1Value);
            }
            if (param2Name != null && param2Name.length() > 0) {
                String[] paramNames2 = BatchProcessor.maybeSplitMultiParam(param2Name);
                if (paramNames2 != null) {
                    char splitc = param2Name.charAt(paramNames2[0].length());
                    String[] paramValues = param2Value.trim().split("\\" + splitc);
                    for (int j = 0; j < paramNames2.length; ++j) {
                        String p = paramNames2[j].trim();
                        String v = paramValues[j].trim();
                        if (!parameterDescriptions.containsKey(p)) {
                            if (p.trim().length() == 0) {
                                throw new IllegalArgumentException("param1Name not set");
                            }
                            throw new IllegalArgumentException("param not found: " + p);
                        }
                        BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(p), p, v);
                        runResults.put(p, (Object)v);
                        scriptParams.put(p, v);
                    }
                } else {
                    if (!parameterDescriptions.containsKey(param2Name) && param2Name.length() == 0) {
                        throw new IllegalArgumentException("param1Name not set");
                    }
                    for (Map.Entry<String, String> e : params.entrySet()) {
                        String pname = e.getKey();
                        if (parameterDescriptions.get(pname) == null) continue;
                        BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(pname), pname, e.getValue());
                    }
                    BatchProcessor.setParam(interp, pwd, parameterDescriptions.get(param2Name), param2Name, param2Value);
                    runResults.put(param2Name, (Object)param2Value);
                    scriptParams.put(param2Name, param2Value);
                }
            }
            long t0 = System.currentTimeMillis();
            if (this.batchDirectory != null) {
                File outf = new File(new File(this.batchDirectory, "stdout"), String.format("%06d", jobNumber));
                if (!outf.getParentFile().exists()) {
                    outf.getParentFile().mkdirs();
                }
                outbaos = new ByteArrayOutputStream();
                outs = new TeeOutputStream((OutputStream)new FileOutputStream(outf), (OutputStream)outbaos);
            } else {
                outs = outbaos = new ByteArrayOutputStream();
            }
            try {
                interp.setOut((OutputStream)outs);
                interp.execfile((InputStream)new ByteArrayInputStream(script.getBytes("US-ASCII")), name);
                String uri = URISplit.format((String)"script", (String)split.resourceUri.toString(), scriptParams);
                String doWriteTemplate = this.writePngTemplate;
                if (doWriteTemplate.length() > 0) {
                    String image = this.doWrite(doWriteTemplate, param1Value, param2Value, uri, myDom);
                    File outf = new File(new File(this.batchDirectory, "images"), String.format("%06d.png", jobNumber));
                    Path target = Paths.get(image, new String[0]);
                    Path link = outf.toPath();
                    Files.createSymbolicLink(link, target, new FileAttribute[0]);
                    runResults.put("writeFile", (Object)image);
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                msg = ex.toString();
                runResults.put("result", (Object)msg);
            }
            catch (IOException | RuntimeException | JSONException ex) {
                msg = ex.toString();
                runResults.put("result", (Object)msg);
            }
            finally {
                outbaos.close();
                runResults.put("stdout", (Object)new String(outbaos.toByteArray(), "US-ASCII"));
                runResults.put("executionTime", System.currentTimeMillis() - t0);
            }
            JSONObject copy = new JSONObject(runResults, JSONObject.getNames((JSONObject)runResults));
            return copy;
        }
        catch (RuntimeException ex) {
            Logger.getLogger(RunBatchTool.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        catch (IOException | JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        int oldThreads = this.threads;
        this.threads = threads;
        this.propertyChangeSupport.firePropertyChange(PROP_THREADS, oldThreads, threads);
    }

    public String getWritePngTemplate() {
        return this.writePngTemplate;
    }

    public void setWritePngTemplate(String writePngTemplate) {
        String oldWritePngTemplate = this.writePngTemplate;
        this.writePngTemplate = writePngTemplate;
        this.propertyChangeSupport.firePropertyChange(PROP_WRITEPNGTEMPLATE, oldWritePngTemplate, writePngTemplate);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.propertyChangeSupport.firePropertyChange(PROP_STATUSMESSAGE, null, statusMessage);
    }

    public File getResultsFile() {
        return this.resultsFile;
    }

    public void setResultsFile(File resultsFile) {
        if (!resultsFile.getName().endsWith(".csv") && !resultsFile.getName().endsWith(".json")) {
            throw new IllegalArgumentException("results file must end with .json or .csv");
        }
        File oldResultsFile = this.resultsFile;
        this.resultsFile = resultsFile;
        this.propertyChangeSupport.firePropertyChange(PROP_RESULTSFILE, oldResultsFile, resultsFile);
    }

    public File getBatchDirectory() {
        return this.batchDirectory;
    }

    public void setBatchDirectory(File batchDirectory) {
        File oldBatchDirectory = this.batchDirectory;
        this.batchDirectory = batchDirectory;
        this.propertyChangeSupport.firePropertyChange(PROP_BATCHDIRECTORY, oldBatchDirectory, batchDirectory);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private static void emptyDirectory(File directory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory.toPath());){
            for (Path entry : stream) {
                if (!Files.isRegularFile(entry, new LinkOption[0])) continue;
                Files.delete(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBatchScript(Application dom, String batchFile, ProgressMonitor monitor) throws IOException {
        int initialThreadCount = this.threads;
        try {
            int ijob;
            int numberOfJobs;
            String[] param2Values;
            String[] param1Values;
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalArgumentException("don't call from event thread");
            }
            URISplit split = URISplit.parse((String)batchFile);
            String pwd = split.path;
            File f = DataSetURI.getFile((String)split.file);
            String batchFileJson = FileUtil.readFileToString((File)f);
            JSONObject jo = new JSONObject(batchFileJson);
            HashMap<String, String> params = new HashMap<String, String>();
            String scriptUri = jo.getString("script");
            if (scriptUri.startsWith("script:")) {
                scriptUri = scriptUri.substring(7);
            }
            String fscriptUri = scriptUri = scriptUri.replaceAll("\\%\\{PWD\\}", pwd);
            URISplit scriptSplit = URISplit.parse((String)scriptUri);
            LinkedHashMap scriptParams = URISplit.parseParams((String)scriptSplit.params);
            File scriptFile = DataSetURI.getFile((String)fscriptUri);
            String script = FileUtil.readFileToString((File)scriptFile);
            params.put("script", fscriptUri);
            params.put("param1", jo.getString("param1"));
            params.put("param2", jo.getString("param2"));
            String param1Name = jo.getString("param1");
            Object oparam1Values = jo.get("param1Values");
            if (oparam1Values instanceof String) {
                param1Values = ((String)oparam1Values).split("\n");
            } else if (oparam1Values instanceof JSONArray) {
                JSONArray jv1 = (JSONArray)oparam1Values;
                param1Values = new String[jv1.length()];
                for (int i = 0; i < jv1.length(); ++i) {
                    param1Values[i] = jv1.getString(i);
                }
            } else {
                throw new IllegalArgumentException("param1Values must be a string or string array");
            }
            String param2Name = jo.getString("param2");
            Object oparam2Values = jo.get("param2Values");
            if (oparam2Values instanceof String) {
                param2Values = ((String)oparam2Values).split("\n");
                if (param2Values.length == 1 && param2Values[0].equals("")) {
                    param2Values = null;
                }
            } else if (oparam2Values instanceof JSONArray) {
                JSONArray jv2 = (JSONArray)oparam2Values;
                param2Values = new String[jv2.length()];
                for (int i = 0; i < jv2.length(); ++i) {
                    param2Values[i] = jv2.getString(i);
                }
            } else {
                throw new IllegalArgumentException("param2Values must be a string or string array");
            }
            AtomicInteger threadCounter = new AtomicInteger(0);
            ThreadFactory tf = r -> new Thread(r, "run-batch-" + threadCounter.incrementAndGet());
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(initialThreadCount, tf);
            ArrayDeque<Long> durationsMillis = new ArrayDeque<Long>();
            AtomicInteger jobNumber = new AtomicInteger(0);
            boolean showEta = "true".equals(System.getProperty("RunBatchTool.eta", "true"));
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("dom", dom);
            env.put("PWD", pwd);
            Map fparameterDescriptions = Util.getParams(env, (String)script, params, (ProgressMonitor)new NullProgressMonitor());
            File lbatchJobsDirectory = null;
            File lbatchPendingDirectory = null;
            File lbatchCompleteDirectory = null;
            boolean batchGuest = false;
            if (this.batchDirectory != null) {
                if (!this.batchDirectory.exists() && !this.batchDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to make directory: " + this.batchDirectory);
                }
                lbatchJobsDirectory = new File(this.batchDirectory, "jobs");
                if (!lbatchJobsDirectory.exists() && !lbatchJobsDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to make directory: " + lbatchJobsDirectory);
                }
                lbatchPendingDirectory = new File(this.batchDirectory, "pending");
                if (!lbatchPendingDirectory.exists() && !lbatchPendingDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to make directory: " + lbatchPendingDirectory);
                }
                lbatchCompleteDirectory = new File(this.batchDirectory, "complete");
                if (!lbatchCompleteDirectory.exists() && !lbatchCompleteDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to make directory: " + lbatchCompleteDirectory);
                }
                File lbatchStdoutDirectory = new File(this.batchDirectory, "stdout");
                if (!lbatchStdoutDirectory.exists() && !lbatchStdoutDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to make directory: " + lbatchStdoutDirectory);
                }
                File lbatchImagesDirectory = new File(this.batchDirectory, "images");
                if (!lbatchImagesDirectory.exists() && !lbatchImagesDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to make directory: " + lbatchImagesDirectory);
                }
                File specificationFile = new File(this.batchDirectory, "main.batch");
                if (specificationFile.exists() && this.isDirectoryEmpty(lbatchJobsDirectory)) {
                    specificationFile.delete();
                }
                if (specificationFile.exists()) {
                    batchGuest = true;
                    logger.info("Running batch as guest");
                } else {
                    try (PrintWriter write = new PrintWriter(specificationFile);){
                        write.append(batchFileJson);
                    }
                    BatchProcessor.emptyDirectory(lbatchJobsDirectory);
                    BatchProcessor.emptyDirectory(lbatchPendingDirectory);
                    BatchProcessor.emptyDirectory(lbatchCompleteDirectory);
                    BatchProcessor.emptyDirectory(lbatchStdoutDirectory);
                    BatchProcessor.emptyDirectory(lbatchImagesDirectory);
                    logger.info("Running batch as host");
                }
            }
            File batchJobsDirectory = lbatchJobsDirectory;
            File batchPendingDirectory = lbatchPendingDirectory;
            File batchCompletedDirectory = lbatchCompleteDirectory;
            JSONObject batchResults = new JSONObject();
            JSONArray resultsStats = new JSONArray();
            batchResults.put("results", (Object)resultsStats);
            JSONArray paramsJson = new JSONArray();
            paramsJson.put(0, (Object)jo.getString("param1"));
            if (jo.getString("param2").length() > 0) {
                paramsJson.put(1, (Object)jo.getString("param2"));
            }
            batchResults.put("params", (Object)paramsJson);
            if (batchPendingDirectory != null && !batchGuest) {
                LinkedHashMap scriptParams1;
                URISplit split1;
                if (param2Values == null || param2Values.length == 0) {
                    split1 = URISplit.parse((String)fscriptUri);
                    scriptParams1 = URISplit.parseParams((String)split1.params);
                    String param1s = jo.getString("param1");
                    scriptParams1.remove(param1s);
                    String baseScriptUriMyName1 = URISplit.format(null, (String)split1.file, (Map)scriptParams1);
                    String hostAndPid = "managerPid: " + AutoplotUtil.getProcessId("XXX") + "\nmanagerHost: " + InetAddress.getLocalHost().getHostName();
                    for (int i = 0; i < param1Values.length; ++i) {
                        int fi = i;
                        File file = new File(batchJobsDirectory, String.format("%06d", fi));
                        PrintWriter write = new PrintWriter(file);
                        Object object = null;
                        try {
                            String scriptURI = baseScriptUriMyName1.endsWith("?") ? baseScriptUriMyName1 + param1s + "=" + param1Values[i] : baseScriptUriMyName1 + "&" + param1s + "=" + param1Values[i];
                            write.println("script: " + scriptURI);
                            write.println(hostAndPid);
                            continue;
                        }
                        catch (Throwable scriptURI) {
                            object = scriptURI;
                            throw scriptURI;
                        }
                        finally {
                            if (write != null) {
                                if (object != null) {
                                    try {
                                        write.close();
                                    }
                                    catch (Throwable scriptURI) {
                                        ((Throwable)object).addSuppressed(scriptURI);
                                    }
                                } else {
                                    write.close();
                                }
                            }
                        }
                    }
                } else {
                    split1 = URISplit.parse((String)fscriptUri);
                    scriptParams1 = URISplit.parseParams((String)split1.params);
                    scriptParams1.remove(param1Name);
                    scriptParams1.remove(param2Name);
                    String baseScriptUriMyName1 = URISplit.format(null, (String)split1.file, (Map)scriptParams1);
                    String hostAndPid = "managerPid: " + AutoplotUtil.getProcessId("XXX") + "\nmanagerHost: " + InetAddress.getLocalHost().getHostName();
                    int i = 0;
                    for (String param1Value : param1Values) {
                        for (String param2Value : param2Values) {
                            File file = new File(batchJobsDirectory, String.format("%06d", i));
                            try (PrintWriter write = new PrintWriter(file);){
                                String scriptURI = baseScriptUriMyName1.endsWith("?") ? baseScriptUriMyName1 + param1Name + "=" + param1Value + "&" + param2Name + "=" + param2Value : baseScriptUriMyName1 + "&" + param1Name + "=" + param1Value + "&" + param2Name + "=" + param2Value;
                                write.println("script: " + scriptURI);
                                write.println(hostAndPid);
                            }
                            ++i;
                        }
                    }
                }
            }
            Settings s = new Settings();
            s.batchJobsDirectory = batchJobsDirectory;
            s.batchPendingDirectory = batchPendingDirectory;
            s.batchCompletedDirectory = batchCompletedDirectory;
            s.pwd = pwd;
            s.fscriptUri = fscriptUri;
            s.script = script;
            s.fparameterDescriptions = fparameterDescriptions;
            s.showEta = showEta;
            s.durationsMillis = durationsMillis;
            s.jobNumber = jobNumber;
            s.resultsStats = resultsStats;
            if (param2Values == null || param2Values.length == 0) {
                numberOfJobs = param1Values.length;
                monitor.setTaskSize((long)numberOfJobs);
                monitor.started();
                ijob = 0;
                for (String param1Value : param1Values) {
                    Runnable runOne = this.setUpOneRun(ijob, param1Name, param1Value, null, null, scriptParams, monitor, s);
                    executor.execute(runOne);
                    ++ijob;
                }
            } else {
                numberOfJobs = param1Values.length * param2Values.length;
                monitor.setTaskSize((long)numberOfJobs);
                monitor.started();
                ijob = 0;
                for (String param1Value : param1Values) {
                    for (String param2Value : param2Values) {
                        Runnable runOne = this.setUpOneRun(ijob, param1Name, param1Value, param2Name, param2Value, scriptParams, monitor, s);
                        executor.execute(runOne);
                        ++ijob;
                    }
                }
            }
            long lastWrite = System.currentTimeMillis();
            long lastReport = System.currentTimeMillis();
            int exportResultsWritten = 0;
            while (!(executor.getActiveCount() == 0 && jobNumber.intValue() == numberOfJobs && this.isDirectoryEmpty(batchPendingDirectory) || monitor.isCancelled())) {
                String report;
                long t = System.currentTimeMillis();
                if (this.resultsFile != null && t - lastWrite > 1000L) {
                    if (!this.resultsFile.getName().endsWith(".json")) {
                        File pendingResultsFile = new File(this.resultsFile.getAbsolutePath() + ".pending");
                        int completed = jobNumber.intValue();
                        int count = completed - exportResultsWritten;
                        BatchProcessor.appendResultsPendingCSV(pendingResultsFile, batchResults, resultsStats, exportResultsWritten, count);
                        String msg = "wrote records " + exportResultsWritten + "-" + completed + " to " + this.resultsFile.getAbsolutePath() + ".pending";
                        this.setStatusMessage(msg);
                        exportResultsWritten = completed;
                    }
                    lastWrite = t;
                }
                if (!showEta || t - lastReport <= 3000L) continue;
                while (durationsMillis.size() > 12) {
                    durationsMillis.removeFirst();
                }
                long timeFor12Jobs = 0L;
                double jobCount = 0.0;
                if (durationsMillis.size() >= 12) {
                    try {
                        Iterator it = durationsMillis.descendingIterator();
                        for (int i = 0; i < 12; ++i) {
                            timeFor12Jobs += ((Long)it.next()).longValue();
                            jobCount += 1.0;
                        }
                    }
                    catch (ConcurrentModificationException it) {
                        // empty catch block
                    }
                }
                long jobsRemaining = executor.getTaskCount() - executor.getCompletedTaskCount();
                if (jobCount > 0.0) {
                    Datum eta = Units.milliseconds.createDatum((double)(jobsRemaining * timeFor12Jobs) / jobCount / (double)executor.getCorePoolSize());
                    eta = DatumUtil.asOrderOneUnits((Datum)eta);
                    String seta = String.format("%.2f%s", eta.value(), eta.getUnits());
                    Datum avgDuration = Units.milliseconds.createDatum((double)timeFor12Jobs / jobCount);
                    avgDuration = DatumUtil.asOrderOneUnits((Datum)avgDuration);
                    String savgDuration = String.format("%.2f%s", avgDuration.value(), avgDuration.getUnits());
                    report = String.format("%d remaining, avg %s, eta %s", jobsRemaining, savgDuration, seta);
                } else {
                    report = String.format("%d remaining", jobsRemaining);
                }
                logger.fine(report);
                this.setStatusMessage(report);
                lastReport = t;
            }
            if (this.resultsFile != null && !this.resultsFile.getName().endsWith(".json")) {
                File pendingResultsFile = new File(this.resultsFile.getAbsolutePath() + ".pending");
                int completed = jobNumber.intValue();
                int count = completed - exportResultsWritten;
                BatchProcessor.appendResultsPendingCSV(pendingResultsFile, batchResults, resultsStats, exportResultsWritten, count);
                String msg = "wrote records " + exportResultsWritten + "-" + completed + " to " + this.resultsFile.getAbsolutePath() + ".pending";
                this.setStatusMessage(msg);
                pendingResultsFile.renameTo(this.resultsFile);
            }
            if (monitor.isCancelled()) {
                executor.shutdownNow();
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(BatchProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (!monitor.isFinished()) {
                monitor.finished();
            }
        }
    }

    private Runnable setUpOneRun(int ijob, String param1Name, String param1Value, String param2Name, String param2Value, Map<String, String> scriptParams, ProgressMonitor monitor, Settings s) throws JSONException {
        int fijob = ijob;
        String fparam1Name = param1Name;
        String fparam2Name = param2Name;
        String fparam1Value = param1Value;
        String fparam2Value = param2Value;
        Map<String, String> fscriptParams = scriptParams;
        JSONObject frunResults = new JSONObject();
        Runnable runOne = () -> this.lambda$setUpOneRun$1(monitor, s, fijob, fscriptParams, fparam1Name, fparam1Value, fparam2Name, fparam2Value, frunResults);
        return runOne;
    }

    private boolean isDirectoryEmpty(File lbatchQueueDirectory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(lbatchQueueDirectory.toPath());){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
    }

    public static void main(String[] args) throws IOException {
        Application dom = new ScriptContext2023().getDocumentModel();
        String batchFile = "https://github.com/autoplot/dev/blob/master/demos/2019/20190726/runBatch2.batch";
        DasProgressPanel monitor = DasProgressPanel.createFramed((String)"Run Batch");
        BatchProcessor processor = new BatchProcessor();
        processor.setWritePngTemplate("/tmp/ap/mypng_%08.3f.png");
        processor.setResultsFile(new File("/tmp/ap/results.csv"));
        processor.setThreads(6);
        processor.runBatchScript(dom, batchFile, (ProgressMonitor)monitor);
        processor.addPropertyChangeListener(PROP_STATUSMESSAGE, evt -> System.err.println(evt.getNewValue()));
        System.err.println("Done!");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$setUpOneRun$1(ProgressMonitor monitor, Settings s, int fijob, Map fscriptParams, String fparam1Name, String fparam1Value, String fparam2Name, String fparam2Value, JSONObject frunResults) {
        if (monitor.isCancelled()) {
            return;
        }
        if (s.batchJobsDirectory != null) {
            var10_10 = this;
            synchronized (var10_10) {
                jobFile = new File(s.batchJobsDirectory, String.format("%06d", new Object[]{fijob}));
                if (!jobFile.exists()) {
                    BatchProcessor.logger.log(Level.FINE, "someone else grabbed {0}", jobFile);
                    return;
                }
                ** try [egrp 2[TRYBLOCK] [12 : 112->212)] { 
lbl12:
                // 1 sources

            }
        }
        ** GOTO lbl45
lbl-1000:
        // 2 sources

        {
            catch (RuntimeException ex) {
                ex.printStackTrace();
                return;
            }
            pendingFile = new File(s.batchPendingDirectory, String.format("%06d", new Object[]{fijob}));
            try {
                Files.move(jobFile.toPath(), pendingFile.toPath(), new CopyOption[]{StandardCopyOption.ATOMIC_MOVE});
            }
            catch (IOException ex) {
                if (jobFile.exists()) {
                    BatchProcessor.logger.log(Level.WARNING, "there was an issue when moving {0}", jobFile);
                }
                BatchProcessor.logger.log(Level.FINE, "someone else grabbed {0}", jobFile);
                // MONITOREXIT @DISABLED, blocks:[13, 14] lbl31 : MonitorExitStatement: MONITOREXIT : var10_10
                if (monitor.isFinished()) {
                    BatchProcessor.logger.fine("monitor reports being finished though it shouldn't have been.");
                    return;
                }
                monitor.setTaskProgress((long)s.jobNumber.incrementAndGet());
                return;
            }
            {
                try {
                    path = pendingFile.toPath();
                    text = "workerHost: " + InetAddress.getLocalHost().getHostName() + "\nworkerPid: " + AutoplotUtil.getProcessId("XXX") + "\nworkerThread: " + Thread.currentThread().getName() + "\n";
                    Files.write(path, text.getBytes(), new OpenOption[]{StandardOpenOption.APPEND});
                }
                catch (IOException ex) {
                    BatchProcessor.logger.log(Level.SEVERE, null, ex);
                }
lbl45:
                // 2 sources

                t0 = System.currentTimeMillis();
                runResults = this.doOneJob(fijob, s.pwd, s.fscriptUri, s.script, s.fparameterDescriptions, fscriptParams, fparam1Name, fparam1Value, fparam2Name, fparam2Value, monitor.getSubtaskMonitor(fparam1Name));
                timeToComplete = System.currentTimeMillis() - t0;
                if (s.showEta) {
                    try {
                        s.durationsMillis.addLast(timeToComplete);
                    }
                    catch (Exception ex) {
                        BatchProcessor.logger.warning("Exception...");
                    }
                }
                if (s.batchJobsDirectory != null) {
                    pendingFile = new File(s.batchPendingDirectory, String.format("%06d", new Object[]{fijob}));
                    completedFile = new File(s.batchCompletedDirectory, String.format("%06d", new Object[]{fijob}));
                    if (!pendingFile.renameTo(completedFile)) {
                        throw new IllegalArgumentException("couldn't rename " + pendingFile);
                    }
                    try {
                        path = completedFile.toPath();
                        exception = runResults.optString("result", "").replaceAll("\n", " ");
                        text = "runTimeMs: " + timeToComplete + "\nexception: " + exception;
                        Files.write(path, text.getBytes(), new OpenOption[]{StandardOpenOption.APPEND});
                    }
                    catch (IOException ex) {
                        BatchProcessor.logger.log(Level.SEVERE, null, ex);
                    }
                }
                if (runResults != null) ** GOTO lbl-1000
            }
        }
        if (monitor.isFinished()) {
            BatchProcessor.logger.fine("monitor reports being finished though it shouldn't have been.");
            return;
        }
        monitor.setTaskProgress((long)s.jobNumber.incrementAndGet());
        return;
lbl-1000:
        // 1 sources

        {
            keyIterator = runResults.keys();
            while (keyIterator.hasNext()) {
                k = (String)keyIterator.next();
                try {
                    frunResults.put(k, runResults.get(k));
                }
                catch (JSONException ex) {
                    BatchProcessor.logger.log(Level.SEVERE, null, ex);
                }
            }
            try {
                s.resultsStats.put(fijob, (Object)runResults);
            }
            catch (JSONException ex) {
                BatchProcessor.logger.log(Level.SEVERE, null, ex);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                BatchProcessor.logger.log(Level.SEVERE, null, ex);
            }
        }
        if (monitor.isFinished()) {
            BatchProcessor.logger.fine("monitor reports being finished though it shouldn't have been.");
            return;
        }
        monitor.setTaskProgress((long)s.jobNumber.incrementAndGet());
        return;
        finally {
            if (monitor.isFinished()) {
                BatchProcessor.logger.fine("monitor reports being finished though it shouldn't have been.");
            } else {
                monitor.setTaskProgress((long)s.jobNumber.incrementAndGet());
            }
        }
    }

    private static class Settings {
        File batchJobsDirectory;
        File batchPendingDirectory;
        String pwd;
        String fscriptUri;
        String script;
        Map<String, Param> fparameterDescriptions;
        boolean showEta;
        Deque<Long> durationsMillis;
        File batchCompletedDirectory;
        AtomicInteger jobNumber;
        JSONArray resultsStats;

        private Settings() {
        }
    }
}

